import javax.swing.JFrame;

import prefuse.Constants;
import prefuse.Display;
import prefuse.data.Node;
import prefuse.Visualization;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.DataColorAction;
import prefuse.controls.DragControl;
import prefuse.controls.PanControl;
import prefuse.controls.ZoomControl;
import prefuse.data.Graph;
import prefuse.data.io.DataIOException;
import prefuse.data.io.GraphMLReader;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.util.ColorLib;
import prefuse.visual.VisualItem;
import prefuse.action.layout.graph.RadialTreeLayout;
import prefuse.action.animate.ColorAnimator;
import prefuse.action.animate.PolarLocationAnimator;
import prefuse.action.animate.QualityControlAnimator;
import prefuse.action.animate.VisibilityAnimator;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.FocusControl;
import prefuse.activity.Activity;
import prefuse.action.layout.CollapsedSubtreeLayout;
import prefuse.action.assignment.DataSizeAction;
import prefuse.action.assignment.SizeAction;
import prefuse.data.query.RangeQueryBinding;


public class Friends {
	  final int ACTIVE = 2;
	  final int INACTIVE = 1;
		
	Visualization vis;
	Graph graph;
	RangeQueryBinding  heartbeat;  

   public Friends(){
	   
	   loadData();
	   visualize();
	   setActions();
	   
   }
   
   
   private void loadData() {

	   
		graph = new Graph();
		graph.addColumn("active", int.class);
		graph.addColumn("name", String.class);
		graph.addColumn("address", String.class);
		graph.addColumn("time",long.class);
		graph.getNodeTable().index("active");
		graph.getNodeTable().index("name");
		graph.getNodeTable().index("address");
		
		Node n1 = graph.addNode();
		n1.set("active", INACTIVE);
		n1.set("name", "");
		n1.set("address", "0007E0C8000Da");
		n1.set("time",0);
/*
		
		graph = null;
		try {
			graph = new GraphMLReader().readGraph("tmp.xml");
		} catch (DataIOException e) {
			e.printStackTrace();
			System.err.println("Errorloading graph. Exiting...");
			System.exit(1);
		}

		graph.getNodeTable().index("active");
		graph.getNodeTable().index("name");
*/
	}
             
   private void visualize(){

	    vis = new Visualization();
        vis.add("graph", graph);
        LabelRenderer r = new LabelRenderer("name");
        r.setRoundedCorner(8, 8); // round the corners       
        vis.setRendererFactory(new DefaultRendererFactory(r));
   }
   
   private void setActions(){        
        
        int[] palette = new int[] {ColorLib.rgba(255,180,180,50),ColorLib.rgba(190,190,255,200)};
        
        // map nominal data values to colors using our provided palette
        DataColorAction fill = new DataColorAction("graph.nodes", "active", Constants.NUMERICAL, VisualItem.FILLCOLOR, palette);
        // use black for node text
        ColorAction text = new ColorAction("graph.nodes", VisualItem.TEXTCOLOR, ColorLib.gray(0));
        // use light grey for edges
        ColorAction edges = new ColorAction("graph.edges", VisualItem.STROKECOLOR, ColorLib.gray(200));//ColorLib.alpha(255));//gray(200));
          
        // create an action list containing all color assignments
        ActionList appearance = new ActionList(Activity.INFINITY);
        appearance.add(fill);
        appearance.add(text);
        appearance.add(edges);
        DataSizeAction dsize = new DataSizeAction("graph.nodes","active");
        appearance.add(dsize);
        vis.putAction("appearance", appearance);
      
        
        ActionList expiry = new ActionList(Activity.INFINITY);
        expiry.add(new ExpiryAction("graph"));
  /*remove for smoothness */      expiry.add(new RepaintAction());
        vis.putAction("expiry", expiry);

        ActionList bluetooth = new ActionList();
        bluetooth.add(new RadialTreeLayout("graph"));
        bluetooth.add(new CollapsedSubtreeLayout("graph"));
        vis.putAction("bluetooth", bluetooth);
        
        ActionList animate = new ActionList(1500);
        animate.setPacingFunction(new SlowInSlowOutPacer());
        animate.add(new QualityControlAnimator());
        animate.add(new VisibilityAnimator("graph"));
        animate.add(new PolarLocationAnimator("graph.nodes", "linear"));
        animate.add(new ColorAnimator("graph.nodes"));
        animate.add(new RepaintAction());
        vis.putAction("animate", animate);
        //vis.alwaysRunAfter("bluetooth","animate");
   }

        
   
   
  public static void main(String[] argv) {
        
        Friends friends = new Friends();
        Display d = new Display(friends.vis);
        d.setSize(720, 500); // set display size
        d.addControlListener(new DragControl());
        d.addControlListener(new PanControl()); 
        d.addControlListener(new ZoomControl());     

        JFrame frame = new JFrame("Friends");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.add(d);
        frame.pack();           
        frame.setVisible(true); 

        friends.vis.run("bluetooth");
        friends.vis.run("appearance");
        friends.vis.run("expiry");
        
        EventHandler eh = new EventHandler(friends);
        

    }
    
}
