import java.util.Calendar;
import java.util.Iterator;
import prefuse.Visualization;
import prefuse.action.GroupAction;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.tuple.TupleSet;
import prefuse.data.expression.parser.*;
import prefuse.data.expression.Predicate;
import prefuse.util.collections.*;

public class ExpiryAction extends GroupAction {
	
	Predicate isActive;
    final int TIMEOUT = 60 * 2 * 1000; // 1 minute in milliseconds

	
    public ExpiryAction(String graphGroup) {
        super(graphGroup);
    
        isActive = (Predicate)ExpressionParser.parse("active = 2");
        
    }
    public void run(double frac) {
 /*   	
		long now = Calendar.getInstance().getTimeInMillis();
    	Graph g = (Graph)m_vis.getGroup("graph");
		IntIterator active_nodes = g.getNodeTable().rows(isActive);
		while(active_nodes.hasNext()){
			int i = active_nodes.nextInt();
			Node node = g.getNode(i);	
			long lastseen = node.getLong("time");
			if(lastseen + 3*1000 < now){
				node.setInt("active", 1);
			}
		}
    }

    	*/
  
    	Graph g = (Graph)m_vis.getGroup("graph");
    	long now = Calendar.getInstance().getTimeInMillis();
    	Iterator active_nodes = g.tuples(isActive);
    	while(active_nodes.hasNext()){
    		Node node = (Node)active_nodes.next();
			long lastseen = node.getLong("time");
			if(lastseen + TIMEOUT < now){
				node.setInt("active", 1);
			} 
    	}
    }
    	
    	
 /*  	
    	Graph g = (Graph) m_vis.getGroup(m_group);
		int size = g.getNodeCount();
		if (g == null || size == 0)
			return;
		for (int i = 0; i < size; i++) {
	//		if (g.getNode(i).getInt("active") == 2) {
				long lastseen = g.getNode(i).getLong("time");
				long now = Calendar.getInstance().getTimeInMillis();
				if (lastseen + 10 * 1000 < now) {
					g.getNode(i).setInt("active", 1);
				}
			}
	//	}
	 
	 */

    
  	
    
    	
    /*
	 * TupleSet focus = m_vis.getGroup(Visualization.FOCUS_ITEMS); if (
	 * focus==null || focus.getTupleCount() == 0 ) return;
	 * 
	 * Graph g = (Graph)m_vis.getGroup(m_group); Node f = null; Iterator tuples =
	 * focus.tuples(); while (tuples.hasNext() &&
	 * !g.containsTuple(f=(Node)tuples.next())) { f = null; } if ( f == null )
	 * return; g.getSpanningTree(f); }
	 */
    	 
}