import java.io.*;
import java.util.*;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.tuple.TupleSet;
import prefuse.data.expression.parser.*;
import prefuse.data.expression.Predicate;
import prefuse.util.collections.*;
import prefuse.data.expression.Predicate;
import prefuse.data.io.GraphMLWriter;


public class EventHandler {

		private Friends friends;
		private Predicate isActive;

		
	public EventHandler(Friends f) {
		int i = 0;
		friends = f;
		isActive = (Predicate) ExpressionParser.parse("[active] = "
				+ friends.ACTIVE);
		while (true) {
			try {
				BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
				String str = "";
				while (str != null) {
					System.out.print(i + " date,time,address,class,name > ");
					str = in.readLine();
					System.out.println(str);
					process(str);
					if (i++ > 1000) {
						i = 0;
						GraphMLWriter gw = new GraphMLWriter();
						gw.writeGraph(friends.graph, "tmp.xml");
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
				System.err.println("Error reading input ...");
			}
		}
	}
	
	int find(String s, Graph g){

	 	int size = g.getNodeCount();
    	for(int i=0; i < size; i++){
    		if((g.getNode(i).getString("address")).compareTo(s) == 0){
    			return i;
    		}
    	}
    	return -1;
 
		/*		
		Predicate query = (Predicate)ExpressionParser.parse("[address] = \""+s+"\"");
		IntIterator nodes = g.getNodeTable().rows(query);
		if(nodes.hasNext()){
			return nodes.nextInt();
		}
		else {
			return -11;
		}
		*/
	}	
	
	void connectActive(){
    	int num_active_nodes = 0;
    	int[] tmp = new int[200]; 
 /*   	
    	Iterator active_nodes = friends.graph.tuples(isActive);
    	while(active_nodes.hasNext()){
    		tmp[num_active_nodes++]= ((Node)active_nodes).getRow();
    	}
*/

	
   	int size = friends.graph.getNodeCount();
    	for(int i=0; i < size; i++){
    		if((friends.graph.getNode(i).getInt("active")) == friends.ACTIVE){
    			tmp[num_active_nodes++]=i;
    		}
    	}
   	
    	for (int i=0; i < num_active_nodes; i++){
			for(int j=i+1; j< num_active_nodes; j++){
				Node n1 = friends.graph.getNode(tmp[i]);
				Node n2 = friends.graph.getNode(tmp[j]);
				if(friends.graph.getEdge(n1,n2)==null){
					friends.graph.addEdge(n1,n2);
				}
			}
		}
	}
	
	void process(String s){
		
		Node node;
		//address,name
		String [] fields = s.split(",");
		//String time = fields[0];
		if(fields.length < 4){
			return;
		}
		String address = fields[2];
		String name = "";
		if(fields.length >4){
			name = fields[4];
		}
		
		if (name.compareTo("(unknown)") == 0){
				return;
			}

		int n = find(address,friends.graph);
		if(n >= 0){
			node = friends.graph.getNode(n);
			if(name.length()<1){
				node.setLong("time", Calendar.getInstance().getTimeInMillis());
			}
			else {
				node.setLong("time", Calendar.getInstance().getTimeInMillis());
				node.setString("name", name);
			}
		}
		else {
			node = friends.graph.addNode();
			node.setString("address", address);
			node.setInt("active", friends.INACTIVE);
			//friends.graph.addEdge(node, friends.graph.getNode(1));
			if(name.length()<1){		
				node.setLong("time", Calendar.getInstance().getTimeInMillis());
				node.setString("name","...");
			}
			else {
				node.setLong("time", Calendar.getInstance().getTimeInMillis());
				node.setString("name", name);
			}	
		}
		
		if(node.getInt("active") == friends.INACTIVE){
			node.setInt("active", friends.ACTIVE);
			connectActive();
			Graph g = (Graph) friends.vis.getGroup("graph");
			g.getSpanningTree(g.getNode(node.getRow()));
			friends.vis.cancel("expiry");
			friends.vis.cancel("appearance");
			friends.vis.run("bluetooth");
			friends.vis.run("animate");
			friends.vis.run("expiry");
			friends.vis.run("appearance");

		}	
		else {
			//connectActive();
		}				
	}
}