import java.io.*;
import java.util.*;
import java.text.SimpleDateFormat;
import java.net.*;
 
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
 

public class Cityware implements DiscoveryListener {
   
   
    //object used for waiting
    private Object lock = new Object();
    private RemoteDevice vecDevices[];
    private DiscoveryAgent agent;
    private SimpleDateFormat date;
    private boolean verbose;
    private String source;
    private String server;
    private String password;
    private String queue;
    private int queue_size;
    
    
    public static void main(String[] args) {

        Cityware myCityware = new Cityware(args);
    }
    
    
    
    public Cityware(String[] args) {
    	
    	try {
    		queue = "";
    		queue_size = 0;
	   		LocalDevice localDevice = LocalDevice.getLocalDevice();
	        source = localDevice.getBluetoothAddress();
	        vecDevices = new RemoteDevice[128];       
	        agent = localDevice.getDiscoveryAgent();
    	} catch (Exception e) {
    		System.err.println("An initialisation error has occured.  Is your Bluetooth enabled?");
    	}
     
  		while(true){    
	        try {
	        	agent.startInquiry(DiscoveryAgent.GIAC, this); 
	            synchronized(lock){
	                lock.wait();
	            }
	        }
	         catch (Exception e) {
  				System.out.println("Cannot start Bluetooth discovery.  Try reseting your Bluetooth dongle.");
  			}

      		for(int i=0; vecDevices[i] != null; i++){
                RemoteDevice remoteDevice = vecDevices[i];
                String name;
                try {
                	name = remoteDevice.getFriendlyName(true);  //winxp: false, osx/linux: true
                	if (name.equals("null") || name.equals(null)){
                		name = "(unknown)";
                	}
                }
                catch (Exception e){
                	name = "(unknown)";
                }
                enqueue(remoteDevice.getBluetoothAddress(),name);
                vecDevices[i]=null;
            }
        }       
    }
    	
    	
    	


    
    
    /**
     * This call back method will be called for each discovered bluetooth device.
     */
    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
       
        //sendData(btDevice.getBluetoothAddress(),cod.getMajorDeviceClass()+"-"+cod.getMinorDeviceClass(),"");
		enqueue(btDevice.getBluetoothAddress(),"");
        int i = 0;
        while(vecDevices[i] != null)
        	{i++;}
        vecDevices[i] = btDevice;
    }
 

    
    
    public void enqueue(String address, String name){
    	
    	queue_size++;
    	String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
    	String time = new SimpleDateFormat("HH:mm:ss").format(new Date());
    	System.out.println(date+","+time+","+address+",0,"+name);

     }
     
     
        
    
    
    
    //no need to implement this method since services are not being discovered
    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {}
 
    //no need to implement this method since services are not being discovered
    public void serviceSearchCompleted(int transID, int respCode) {}
   
    /**
     * This callback method will be called when the device discovery is completed.
     */
    public void inquiryCompleted(int discType) {
	
		synchronized(lock){
            lock.notify();
        }  
        switch (discType) {
            case DiscoveryListener.INQUIRY_COMPLETED :
                break;
               
            case DiscoveryListener.INQUIRY_TERMINATED :
                System.err.println("An error has occured: INQUIRY_TERMINATED.");
                break;
               
            case DiscoveryListener.INQUIRY_ERROR :
                System.err.println("An error has occured:  INQUIRY_ERROR.");
                break;
 
            default :
                System.err.println("An error has occured: Unknown Response Code.");
                break;
        }
    }
    
    

    
}