/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import prefuse.util.force.AbstractForce;
import prefuse.util.force.ForceItem;
import prefuse.util.force.Spring;

public class SpringForce
extends AbstractForce {
    private static String[] pnames = new String[]{"SpringCoefficient", "DefaultSpringLength"};
    public static final float DEFAULT_SPRING_COEFF = 1.0E-4f;
    public static final float DEFAULT_MAX_SPRING_COEFF = 0.001f;
    public static final float DEFAULT_MIN_SPRING_COEFF = 1.0E-5f;
    public static final float DEFAULT_SPRING_LENGTH = 50.0f;
    public static final float DEFAULT_MIN_SPRING_LENGTH = 0.0f;
    public static final float DEFAULT_MAX_SPRING_LENGTH = 200.0f;
    public static final int SPRING_COEFF = 0;
    public static final int SPRING_LENGTH = 1;

    public SpringForce(float f, float f2) {
        this.params = new float[]{f, f2};
        this.minValues = new float[]{1.0E-5f, 0.0f};
        this.maxValues = new float[]{0.001f, 200.0f};
    }

    public SpringForce() {
        this(1.0E-4f, 50.0f);
    }

    public boolean isSpringForce() {
        return true;
    }

    protected String[] getParameterNames() {
        return pnames;
    }

    public void getForce(Spring spring) {
        ForceItem forceItem = spring.item1;
        ForceItem forceItem2 = spring.item2;
        float f = spring.length < 0.0f ? this.params[1] : spring.length;
        float f2 = forceItem2.location[0];
        float f3 = forceItem.location[0];
        float f4 = f2 - f3;
        float f5 = forceItem2.location[1];
        float f6 = forceItem.location[1];
        float f7 = f5 - f6;
        float f8 = (float)Math.sqrt(f4 * f4 + f7 * f7);
        if ((double)f8 == 0.0) {
            f4 = ((float)Math.random() - 0.5f) / 50.0f;
            f7 = ((float)Math.random() - 0.5f) / 50.0f;
            f8 = (float)Math.sqrt(f4 * f4 + f7 * f7);
        }
        float f9 = f8 - f;
        float f10 = (spring.coeff < 0.0f ? this.params[0] : spring.coeff) * f9 / f8;
        forceItem.force[0] = forceItem.force[0] + f10 * f4;
        forceItem.force[1] = forceItem.force[1] + f10 * f7;
        forceItem2.force[0] = forceItem2.force[0] + -f10 * f4;
        forceItem2.force[1] = forceItem2.force[1] + -f10 * f7;
    }
}

