/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.display;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;

public class Clip {
    private static final byte EMPTY = 0;
    private static final byte INUSE = 1;
    private static final byte INVALID = 2;
    private double[] clip = new double[8];
    private byte status = (byte)2;

    public void reset() {
        this.status = 0;
    }

    public void invalidate() {
        this.status = (byte)2;
    }

    public void setClip(Clip clip) {
        this.status = 1;
        System.arraycopy(clip.clip, 0, this.clip, 0, this.clip.length);
    }

    public void setClip(Rectangle2D rectangle2D) {
        this.setClip(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void setClip(double d, double d2, double d3, double d4) {
        this.status = 1;
        this.clip[0] = d;
        this.clip[1] = d2;
        this.clip[6] = d + d3;
        this.clip[7] = d2 + d4;
    }

    public void transform(AffineTransform affineTransform) {
        this.clip[2] = this.clip[0];
        this.clip[3] = this.clip[7];
        this.clip[4] = this.clip[6];
        this.clip[5] = this.clip[1];
        affineTransform.transform(this.clip, 0, this.clip, 0, 4);
        double d = this.clip[0];
        double d2 = this.clip[1];
        double d3 = this.clip[6];
        double d4 = this.clip[7];
        for (int i = 0; i < 7; i += 2) {
            if (this.clip[i] < d) {
                d = this.clip[i];
            }
            if (this.clip[i] > d3) {
                d3 = this.clip[i];
            }
            if (this.clip[i + 1] < d2) {
                d2 = this.clip[i + 1];
            }
            if (!(this.clip[i + 1] > d4)) continue;
            d4 = this.clip[i + 1];
        }
        this.clip[0] = d;
        this.clip[1] = d2;
        this.clip[6] = d3;
        this.clip[7] = d4;
    }

    public void limit(double d, double d2, double d3, double d4) {
        this.clip[0] = Math.max(this.clip[0], d);
        this.clip[1] = Math.max(this.clip[1], d2);
        this.clip[6] = Math.min(this.clip[6], d3);
        this.clip[7] = Math.min(this.clip[7], d4);
    }

    public boolean intersects(Rectangle2D rectangle2D, double d) {
        double d2 = this.clip[6] - this.clip[0];
        double d3 = this.clip[7] - this.clip[1];
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        if (d4 < 0.0 || d5 < 0.0 || d2 < 0.0 || d3 < 0.0) {
            return false;
        }
        double d6 = this.clip[0];
        double d7 = this.clip[1];
        double d8 = rectangle2D.getX() - d;
        double d9 = rectangle2D.getY() - d;
        return ((d4 += d8 + 2.0 * d) < d8 || d4 > d6) && ((d5 += d9 + 2.0 * d) < d9 || d5 > d7) && ((d2 += d6) < d6 || d2 > d8) && ((d3 += d7) < d7 || d3 > d9);
    }

    public void union(Clip clip) {
        if (this.status == 2) {
            return;
        }
        if (this.status == 0) {
            this.setClip(clip);
            this.status = 1;
            return;
        }
        this.clip[0] = Math.min(this.clip[0], clip.clip[0]);
        this.clip[1] = Math.min(this.clip[1], clip.clip[1]);
        this.clip[6] = Math.max(this.clip[6], clip.clip[6]);
        this.clip[7] = Math.max(this.clip[7], clip.clip[7]);
    }

    public void union(Rectangle2D rectangle2D) {
        if (this.status == 2) {
            return;
        }
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMinY();
        double d3 = rectangle2D.getMaxX();
        double d4 = rectangle2D.getMaxY();
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d4)) {
            Logger.getLogger(this.getClass().getName()).warning("Union with invalid clip region: " + rectangle2D);
            return;
        }
        if (this.status == 0) {
            this.setClip(rectangle2D);
            this.status = 1;
            return;
        }
        this.clip[0] = Math.min(this.clip[0], d);
        this.clip[1] = Math.min(this.clip[1], d2);
        this.clip[6] = Math.max(this.clip[6], d3);
        this.clip[7] = Math.max(this.clip[7], d4);
    }

    public void union(double d, double d2, double d3, double d4) {
        if (this.status == 2) {
            return;
        }
        if (this.status == 0) {
            this.setClip(d, d2, d3, d4);
            this.status = 1;
            return;
        }
        this.clip[0] = Math.min(this.clip[0], d);
        this.clip[1] = Math.min(this.clip[1], d2);
        this.clip[6] = Math.max(this.clip[6], d + d3);
        this.clip[7] = Math.max(this.clip[7], d2 + d4);
    }

    public void intersection(Clip clip) {
        if (this.status == 2) {
            return;
        }
        if (this.status == 0) {
            this.setClip(clip);
            this.status = 1;
            return;
        }
        this.clip[0] = Math.max(this.clip[0], clip.clip[0]);
        this.clip[1] = Math.max(this.clip[1], clip.clip[1]);
        this.clip[6] = Math.min(this.clip[6], clip.clip[6]);
        this.clip[7] = Math.min(this.clip[7], clip.clip[7]);
    }

    public void intersection(Rectangle2D rectangle2D) {
        if (this.status == 2) {
            return;
        }
        if (this.status == 0) {
            this.setClip(rectangle2D);
            this.status = 1;
            return;
        }
        this.clip[0] = Math.max(this.clip[0], rectangle2D.getMinX());
        this.clip[1] = Math.max(this.clip[1], rectangle2D.getMinY());
        this.clip[6] = Math.min(this.clip[6], rectangle2D.getMaxX());
        this.clip[7] = Math.min(this.clip[7], rectangle2D.getMaxY());
    }

    public void intersection(double d, double d2, double d3, double d4) {
        if (this.status == 2) {
            return;
        }
        if (this.status == 0) {
            this.setClip(d, d2, d3, d4);
            this.status = 1;
            return;
        }
        this.clip[0] = Math.max(this.clip[0], d);
        this.clip[1] = Math.max(this.clip[1], d2);
        this.clip[6] = Math.min(this.clip[6], d + d3);
        this.clip[7] = Math.min(this.clip[7], d2 + d4);
    }

    public void expandToIntegerLimits() {
        this.clip[0] = Math.floor(this.clip[0]);
        this.clip[1] = Math.floor(this.clip[1]);
        this.clip[6] = Math.ceil(this.clip[6]);
        this.clip[7] = Math.ceil(this.clip[7]);
    }

    public void expand(double d) {
        this.clip[0] = this.clip[0] - d;
        this.clip[1] = this.clip[1] - d;
        this.clip[6] = this.clip[6] + d;
        this.clip[7] = this.clip[7] + d;
    }

    public void grow(double d) {
        this.clip[6] = this.clip[6] + d;
        this.clip[7] = this.clip[7] + d;
    }

    public double getMinX() {
        return this.clip[0];
    }

    public double getMinY() {
        return this.clip[1];
    }

    public double getMaxX() {
        return this.clip[6];
    }

    public double getMaxY() {
        return this.clip[7];
    }

    public double getWidth() {
        return this.clip[6] - this.clip[0];
    }

    public double getHeight() {
        return this.clip[7] - this.clip[1];
    }

    public boolean isEmpty() {
        return this.status == 0;
    }

    public boolean isInvalid() {
        return this.status == 2;
    }

    public boolean equals(Object object) {
        if (object instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)object;
            return rectangle2D.getMinX() == this.clip[0] && rectangle2D.getMinY() == this.clip[1] && rectangle2D.getMaxX() == this.clip[6] && rectangle2D.getMaxY() == this.clip[7];
        }
        if (object instanceof Clip) {
            Clip clip = (Clip)object;
            if (clip.status == this.status) {
                if (this.status == 1) {
                    return clip.clip[0] == this.clip[0] && clip.clip[1] == this.clip[1] && clip.clip[6] == this.clip[6] && clip.clip[7] == this.clip[7];
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("Clip[");
        switch (this.status) {
            case 2: {
                stringBuffer.append("invalid");
                break;
            }
            case 0: {
                stringBuffer.append("empty");
                break;
            }
            default: {
                stringBuffer.append(this.clip[0]).append(",");
                stringBuffer.append(this.clip[1]).append(",");
                stringBuffer.append(this.clip[6]).append(",");
                stringBuffer.append(this.clip[7]);
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

