/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.display;

import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import prefuse.Display;
import prefuse.util.display.Clip;
import prefuse.util.display.PaintListener;
import prefuse.util.io.IOLib;

public class BackgroundPainter
implements PaintListener {
    private static final double THRESH = 0.01;
    private Image m_img;
    private boolean m_fixed;
    private boolean m_tiled;
    private AffineTransform m_identity;
    private Clip m_clip;

    public BackgroundPainter(String string, boolean bl, boolean bl2) {
        this(Toolkit.getDefaultToolkit().getImage(IOLib.urlFromString(string)), bl, bl2);
    }

    public BackgroundPainter(Image image, boolean bl, boolean bl2) {
        this.m_img = image;
        MediaTracker mediaTracker = new MediaTracker(new Container());
        mediaTracker.addImage(this.m_img, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        mediaTracker.removeImage(this.m_img, 0);
        this.m_fixed = bl;
        this.m_tiled = bl2;
    }

    public void prePaint(Display display, Graphics2D graphics2D) {
        AffineTransform affineTransform = graphics2D.getTransform();
        boolean bl = BackgroundPainter.isTranslation(affineTransform);
        if (this.m_fixed || bl) {
            int n = this.m_fixed ? 0 : (int)affineTransform.getTranslateX();
            int n2 = this.m_fixed ? 0 : (int)affineTransform.getTranslateY();
            graphics2D.setTransform(this.getIdentity());
            if (this.m_tiled) {
                int n3;
                int n4 = display.getWidth();
                int n5 = this.m_img.getWidth(null);
                int n6 = display.getHeight();
                int n7 = this.m_img.getHeight(null);
                int n8 = this.m_fixed ? 0 : n % n5;
                int n9 = n3 = this.m_fixed ? 0 : n2 % n7;
                if (n8 > 0) {
                    n8 -= n5;
                }
                if (n3 > 0) {
                    n3 -= n7;
                }
                for (int i = n8; i < n4 - n8; i += n5) {
                    for (int j = n3; j < n6 - n3; j += n7) {
                        graphics2D.drawImage(this.m_img, i, j, null);
                    }
                }
            } else {
                graphics2D.drawImage(this.m_img, n, n2, null);
            }
            graphics2D.setTransform(affineTransform);
        } else if (this.m_tiled) {
            int n = this.m_img.getWidth(null);
            int n10 = this.m_img.getHeight(null);
            Clip clip = this.getClip();
            clip.setClip(0.0, 0.0, display.getWidth(), display.getHeight());
            clip.transform(display.getInverseTransform());
            int n11 = (int)Math.ceil(clip.getWidth());
            int n12 = (int)Math.ceil(clip.getHeight());
            int n13 = (int)clip.getMinX();
            int n14 = (int)clip.getMinY();
            int n15 = n13 % n + n;
            int n16 = n14 % n10 + n10;
            n11 += n15;
            n14 -= n16;
            n12 += n16;
            for (int i = n13 -= n15; i < n13 + n11; i += n) {
                for (int j = n14; j < n14 + n12; j += n10) {
                    graphics2D.drawImage(this.m_img, i, j, null);
                }
            }
        } else {
            graphics2D.drawImage(this.m_img, 0, 0, null);
        }
    }

    private static boolean isTranslation(AffineTransform affineTransform) {
        return Math.abs(affineTransform.getScaleX() - 1.0) < 0.01 && Math.abs(affineTransform.getScaleY() - 1.0) < 0.01 && Math.abs(affineTransform.getShearX()) < 0.01 && Math.abs(affineTransform.getShearY()) < 0.01;
    }

    private AffineTransform getIdentity() {
        if (this.m_identity == null) {
            this.m_identity = new AffineTransform();
        }
        return this.m_identity;
    }

    private Clip getClip() {
        if (this.m_clip == null) {
            this.m_clip = new Clip();
        }
        return this.m_clip;
    }

    public void postPaint(Display display, Graphics2D graphics2D) {
    }
}

