/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import prefuse.render.AbstractShapeRenderer;
import prefuse.util.ColorLib;
import prefuse.util.GraphicsLib;
import prefuse.util.StrokeLib;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class EdgeRenderer
extends AbstractShapeRenderer {
    public static final String EDGE_TYPE = "edgeType";
    protected static final double HALF_PI = 1.5707963267948966;
    protected Line2D m_line = new Line2D.Float();
    protected CubicCurve2D m_cubic = new CubicCurve2D.Float();
    protected int m_edgeType = 0;
    protected int m_xAlign1 = 2;
    protected int m_yAlign1 = 2;
    protected int m_xAlign2 = 2;
    protected int m_yAlign2 = 2;
    protected double m_width = 1.0;
    protected float m_curWidth = 1.0f;
    protected Point2D[] m_tmpPoints = new Point2D[2];
    protected Point2D[] m_ctrlPoints = new Point2D[2];
    protected Point2D[] m_isctPoints = new Point2D[2];
    protected int m_edgeArrow = 1;
    protected int m_arrowWidth = 8;
    protected int m_arrowHeight = 12;
    protected Polygon m_arrowHead = this.updateArrowHead(this.m_arrowWidth, this.m_arrowHeight);
    protected AffineTransform m_arrowTrans = new AffineTransform();
    protected Shape m_curArrow;

    public EdgeRenderer() {
        this.m_tmpPoints[0] = new Point2D.Float();
        this.m_tmpPoints[1] = new Point2D.Float();
        this.m_ctrlPoints[0] = new Point2D.Float();
        this.m_ctrlPoints[1] = new Point2D.Float();
        this.m_isctPoints[0] = new Point2D.Float();
        this.m_isctPoints[1] = new Point2D.Float();
    }

    public EdgeRenderer(int n) {
        this(n, 1);
    }

    public EdgeRenderer(int n, int n2) {
        this();
        this.setEdgeType(n);
        this.setArrowType(n2);
    }

    public int getRenderType(VisualItem visualItem) {
        return 1;
    }

    protected Shape getRawShape(VisualItem visualItem) {
        EdgeItem edgeItem = (EdgeItem)visualItem;
        NodeItem nodeItem = edgeItem.getSourceItem();
        NodeItem nodeItem2 = edgeItem.getTargetItem();
        int n = this.m_edgeType;
        EdgeRenderer.getAlignedPoint(this.m_tmpPoints[0], nodeItem.getBounds(), this.m_xAlign1, this.m_yAlign1);
        EdgeRenderer.getAlignedPoint(this.m_tmpPoints[1], nodeItem2.getBounds(), this.m_xAlign2, this.m_yAlign2);
        this.m_curWidth = (float)(this.m_width * this.getLineWidth(visualItem));
        EdgeItem edgeItem2 = (EdgeItem)visualItem;
        if (edgeItem2.isDirected() && this.m_edgeArrow != 0) {
            NodeItem nodeItem3;
            boolean bl = this.m_edgeArrow == 1;
            Point2D point2D = null;
            Point2D point2D2 = null;
            point2D = this.m_tmpPoints[bl ? 0 : 1];
            int n2 = GraphicsLib.intersectLineRectangle(point2D, point2D2 = this.m_tmpPoints[bl ? 1 : 0], (nodeItem3 = bl ? edgeItem2.getTargetItem() : edgeItem2.getSourceItem()).getBounds(), this.m_isctPoints);
            if (n2 > 0) {
                point2D2 = this.m_isctPoints[0];
            }
            AffineTransform affineTransform = this.getArrowTrans(point2D, point2D2, this.m_curWidth);
            this.m_curArrow = affineTransform.createTransformedShape(this.m_arrowHead);
            Point2D point2D3 = this.m_tmpPoints[bl ? 1 : 0];
            point2D3.setLocation(0.0, -this.m_arrowHeight);
            affineTransform.transform(point2D3, point2D3);
        } else {
            this.m_curArrow = null;
        }
        Shape shape = null;
        double d = this.m_tmpPoints[0].getX();
        double d2 = this.m_tmpPoints[0].getY();
        double d3 = this.m_tmpPoints[1].getX();
        double d4 = this.m_tmpPoints[1].getY();
        switch (n) {
            case 0: {
                this.m_line.setLine(d, d2, d3, d4);
                shape = this.m_line;
                break;
            }
            case 1: {
                this.getCurveControlPoints(edgeItem, this.m_ctrlPoints, d, d2, d3, d4);
                this.m_cubic.setCurve(d, d2, this.m_ctrlPoints[0].getX(), this.m_ctrlPoints[0].getY(), this.m_ctrlPoints[1].getX(), this.m_ctrlPoints[1].getY(), d3, d4);
                shape = this.m_cubic;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown edge type");
            }
        }
        return shape;
    }

    public void render(Graphics2D graphics2D, VisualItem visualItem) {
        super.render(graphics2D, visualItem);
        if (this.m_curArrow != null) {
            graphics2D.setPaint(ColorLib.getColor(visualItem.getFillColor()));
            graphics2D.fill(this.m_curArrow);
        }
    }

    protected AffineTransform getArrowTrans(Point2D point2D, Point2D point2D2, double d) {
        this.m_arrowTrans.setToTranslation(point2D2.getX(), point2D2.getY());
        this.m_arrowTrans.rotate(-1.5707963267948966 + Math.atan2(point2D2.getY() - point2D.getY(), point2D2.getX() - point2D.getX()));
        if (d > 1.0) {
            double d2 = d / 4.0;
            this.m_arrowTrans.scale(d2, d2);
        }
        return this.m_arrowTrans;
    }

    protected Polygon updateArrowHead(int n, int n2) {
        if (this.m_arrowHead == null) {
            this.m_arrowHead = new Polygon();
        } else {
            this.m_arrowHead.reset();
        }
        this.m_arrowHead.addPoint(0, 0);
        this.m_arrowHead.addPoint(-n / 2, -n2);
        this.m_arrowHead.addPoint(n / 2, -n2);
        this.m_arrowHead.addPoint(0, 0);
        return this.m_arrowHead;
    }

    protected AffineTransform getTransform(VisualItem visualItem) {
        return null;
    }

    public boolean locatePoint(Point2D point2D, VisualItem visualItem) {
        Shape shape = this.getShape(visualItem);
        if (shape == null) {
            return false;
        }
        double d = Math.max(2.0, this.getLineWidth(visualItem));
        double d2 = d / 2.0;
        return shape.intersects(point2D.getX() - d2, point2D.getY() - d2, d, d);
    }

    public void setBounds(VisualItem visualItem) {
        if (!this.m_manageBounds) {
            return;
        }
        Shape shape = this.getShape(visualItem);
        if (shape == null) {
            visualItem.setBounds(visualItem.getX(), visualItem.getY(), 0.0, 0.0);
            return;
        }
        GraphicsLib.setBounds(visualItem, shape, this.getStroke(visualItem));
        if (this.m_curArrow != null) {
            Rectangle2D rectangle2D = (Rectangle2D)visualItem.get(VisualItem.BOUNDS);
            Rectangle2D.union(rectangle2D, this.m_curArrow.getBounds2D(), rectangle2D);
        }
    }

    protected double getLineWidth(VisualItem visualItem) {
        return visualItem.getSize();
    }

    protected BasicStroke getStroke(VisualItem visualItem) {
        return StrokeLib.getDerivedStroke(visualItem.getStroke(), this.m_curWidth);
    }

    protected void getCurveControlPoints(EdgeItem edgeItem, Point2D[] point2DArray, double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        point2DArray[0].setLocation(d + 2.0 * d5 / 3.0, d2);
        point2DArray[1].setLocation(d3 - d5 / 8.0, d4 - d6 / 8.0);
    }

    protected static void getAlignedPoint(Point2D point2D, Rectangle2D rectangle2D, int n, int n2) {
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        if (n == 2) {
            d += d3 / 2.0;
        } else if (n == 1) {
            d += d3;
        }
        if (n2 == 2) {
            d2 += d4 / 2.0;
        } else if (n2 == 3) {
            d2 += d4;
        }
        point2D.setLocation(d, d2);
    }

    public int getEdgeType() {
        return this.m_edgeType;
    }

    public void setEdgeType(int n) {
        if (n < 0 || n >= 2) {
            throw new IllegalArgumentException("Unrecognized edge curve type: " + n);
        }
        this.m_edgeType = n;
    }

    public int getArrowType() {
        return this.m_edgeArrow;
    }

    public void setArrowType(int n) {
        if (n < 0 || n >= 3) {
            throw new IllegalArgumentException("Unrecognized edge arrow type: " + n);
        }
        this.m_edgeArrow = n;
    }

    public void setArrowHeadSize(int n, int n2) {
        this.m_arrowWidth = n;
        this.m_arrowHeight = n2;
        this.m_arrowHead = this.updateArrowHead(n, n2);
    }

    public int getArrowHeadHeight() {
        return this.m_arrowHeight;
    }

    public int getArrowHeadWidth() {
        return this.m_arrowWidth;
    }

    public int getHorizontalAlignment1() {
        return this.m_xAlign1;
    }

    public int getVerticalAlignment1() {
        return this.m_yAlign1;
    }

    public int getHorizontalAlignment2() {
        return this.m_xAlign2;
    }

    public int getVerticalAlignment2() {
        return this.m_yAlign2;
    }

    public void setHorizontalAlignment1(int n) {
        this.m_xAlign1 = n;
    }

    public void setVerticalAlignment1(int n) {
        this.m_yAlign1 = n;
    }

    public void setHorizontalAlignment2(int n) {
        this.m_xAlign2 = n;
    }

    public void setVerticalAlignment2(int n) {
        this.m_yAlign2 = n;
    }

    public void setDefaultLineWidth(double d) {
        this.m_width = d;
    }

    public double getDefaultLineWidth() {
        return this.m_width;
    }
}

