/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.Iterator;
import prefuse.data.Edge;
import prefuse.data.Node;
import prefuse.data.Tuple;
import prefuse.util.collections.Queue;

public class BreadthFirstIterator
implements Iterator {
    protected Queue m_queue = new Queue();
    protected int m_depth;
    protected int m_traversal;
    protected boolean m_includeNodes;
    protected boolean m_includeEdges;

    public BreadthFirstIterator() {
    }

    public BreadthFirstIterator(Node node, int n, int n2) {
        this.init(new Node[]{node}, n, n2);
    }

    public BreadthFirstIterator(Iterator iterator, int n, int n2) {
        this.init(iterator, n, n2);
    }

    public void init(Object object, int n, int n2) {
        this.m_queue.clear();
        this.m_depth = n;
        if (n2 < 0 || n2 >= 3) {
            throw new IllegalArgumentException("Unrecognized traversal type: " + n2);
        }
        this.m_traversal = n2;
        this.m_includeNodes = n2 == 0 || n2 == 2;
        boolean bl = this.m_includeEdges = n2 == 1 || n2 == 2;
        if (this.m_includeNodes) {
            if (object instanceof Node) {
                this.m_queue.add(object, 0);
            } else {
                Iterator iterator = (Iterator)object;
                while (iterator.hasNext()) {
                    this.m_queue.add(iterator.next(), 0);
                }
            }
        } else if (object instanceof Node) {
            Node node = (Node)object;
            this.m_queue.visit(node, 0);
            Iterator iterator = this.getEdges(node);
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                Node node2 = edge.getAdjacentNode(node);
                this.m_queue.visit(node2, 1);
                if (this.m_queue.getDepth(edge) >= 0) continue;
                this.m_queue.add(edge, 1);
            }
        } else {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                this.m_queue.visit(node, 0);
                Iterator iterator2 = this.getEdges(node);
                while (iterator2.hasNext()) {
                    Edge edge = (Edge)iterator2.next();
                    Node node3 = edge.getAdjacentNode(node);
                    this.m_queue.visit(node3, 1);
                    if (this.m_queue.getDepth(edge) >= 0) continue;
                    this.m_queue.add(edge, 1);
                }
            }
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        return !this.m_queue.isEmpty();
    }

    protected Iterator getEdges(Node node) {
        return node.edges();
    }

    public int getDepth(Tuple tuple) {
        return this.m_queue.getDepth(tuple);
    }

    public Object next() {
        Tuple tuple = (Tuple)this.m_queue.removeFirst();
        switch (this.m_traversal) {
            case 0: 
            case 2: {
                if (tuple instanceof Edge) {
                    return tuple;
                }
                Node node = (Node)tuple;
                int n = this.m_queue.getDepth(node);
                if (n < this.m_depth) {
                    int n2 = n + 1;
                    Iterator iterator = this.getEdges(node);
                    while (iterator.hasNext()) {
                        Edge edge = (Edge)iterator.next();
                        Node node2 = edge.getAdjacentNode(node);
                        if (this.m_includeEdges && this.m_queue.getDepth(edge) < 0) {
                            this.m_queue.add(edge, n2);
                        }
                        if (this.m_queue.getDepth(node2) >= 0) continue;
                        this.m_queue.add(node2, n2);
                    }
                } else if (this.m_includeEdges && n == this.m_depth) {
                    Iterator iterator = this.getEdges(node);
                    while (iterator.hasNext()) {
                        Edge edge = (Edge)iterator.next();
                        Node node3 = edge.getAdjacentNode(node);
                        int n3 = this.m_queue.getDepth(node3);
                        if (n3 <= 0 || this.m_queue.getDepth(edge) >= 0) continue;
                        this.m_queue.add(edge, Math.min(n, n3));
                    }
                }
                return node;
            }
            case 1: {
                Edge edge = (Edge)tuple;
                Node node = edge.getSourceNode();
                Node node4 = edge.getTargetNode();
                int n = this.m_queue.getDepth(node);
                int n4 = this.m_queue.getDepth(node4);
                if (n != n4) {
                    Node node5 = n4 > n ? node4 : node;
                    int n5 = Math.max(n, n4);
                    if (n5 < this.m_depth) {
                        int n6 = n5 + 1;
                        Iterator iterator = this.getEdges(node5);
                        while (iterator.hasNext()) {
                            Edge edge2 = (Edge)iterator.next();
                            if (this.m_queue.getDepth(edge2) >= 0) continue;
                            Node node6 = edge2.getAdjacentNode(node5);
                            this.m_queue.visit(node6, n6);
                            this.m_queue.add(edge2, n6);
                        }
                    }
                }
                return edge;
            }
        }
        throw new IllegalStateException();
    }
}

