/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.search;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import prefuse.data.Tuple;
import prefuse.data.search.SearchTupleSet;
import prefuse.data.tuple.DefaultTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.util.StringLib;

public class RegexSearchTupleSet
extends SearchTupleSet {
    private String m_query = "";
    private boolean m_caseSensitive;
    private LinkedHashMap m_source = new LinkedHashMap();

    public RegexSearchTupleSet() {
        this(false);
    }

    public RegexSearchTupleSet(boolean bl) {
        this.m_caseSensitive = bl;
    }

    public String getQuery() {
        return this.m_query;
    }

    public void search(String string) {
        Tuple[] tupleArray3;
        if (string == null) {
            string = "";
        }
        if (!this.m_caseSensitive) {
            string = string.toLowerCase();
        }
        if (string.equals(this.m_query)) {
            return;
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(string);
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.warning("Pattern compile failed.\n" + StringLib.getStackTrace(exception));
            return;
        }
        Tuple[] tupleArray2 = this.clearInternal();
        this.m_query = string;
        for (Tuple[] tupleArray3 : this.m_source.keySet()) {
            TupleSet tupleSet = (TupleSet)this.m_source.get(tupleArray3);
            Iterator iterator = tupleSet.tuples();
            while (iterator.hasNext()) {
                Tuple tuple = (Tuple)iterator.next();
                String string2 = tuple.getString((String)tupleArray3);
                if (!this.m_caseSensitive) {
                    string2 = string2.toLowerCase();
                }
                if (!pattern.matcher(string2).matches()) continue;
                this.addInternal(tuple);
            }
        }
        tupleArray3 = this.getTupleCount() > 0 ? this.toArray() : null;
        this.fireTupleEvent(tupleArray3, tupleArray2);
    }

    public void index(Tuple tuple, String string) {
        TupleSet tupleSet = (TupleSet)this.m_source.get(string);
        if (tupleSet == null) {
            tupleSet = new DefaultTupleSet();
            this.m_source.put(string, tupleSet);
        }
        tupleSet.addTuple(tuple);
    }

    public void unindex(Tuple tuple, String string) {
        TupleSet tupleSet = (TupleSet)this.m_source.get(string);
        if (tupleSet != null) {
            tupleSet.removeTuple(tuple);
        }
    }

    public boolean isUnindexSupported() {
        return true;
    }

    public void clear() {
        this.m_source.clear();
        super.clear();
    }
}

