/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.query;

import javax.swing.JComponent;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.AbstractPredicate;
import prefuse.data.query.DynamicQueryBinding;
import prefuse.data.search.PrefixSearchTupleSet;
import prefuse.data.search.SearchTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ui.JSearchPanel;
import prefuse.visual.VisualTupleSet;

public class SearchQueryBinding
extends DynamicQueryBinding {
    private SearchTupleSet m_set;
    private Listener m_lstnr = new Listener();
    private Object m_lock;

    public SearchQueryBinding(TupleSet tupleSet, String string) {
        this(tupleSet, string, new PrefixSearchTupleSet());
    }

    public SearchQueryBinding(TupleSet tupleSet, String string, SearchTupleSet searchTupleSet) {
        super(tupleSet, string);
        this.setPredicate(new SearchBindingPredicate());
        this.m_set = searchTupleSet;
        this.m_set.index(tupleSet.tuples(), string);
        this.m_set.addTupleSetListener(this.m_lstnr);
        if (tupleSet instanceof VisualTupleSet) {
            this.m_lock = ((VisualTupleSet)tupleSet).getVisualization();
        }
    }

    public SearchTupleSet getSearchSet() {
        return this.m_set;
    }

    public JComponent createComponent() {
        return this.createSearchPanel();
    }

    public JSearchPanel createSearchPanel() {
        return this.createSearchPanel(this.m_set instanceof PrefixSearchTupleSet);
    }

    public JSearchPanel createSearchPanel(boolean bl) {
        JSearchPanel jSearchPanel = new JSearchPanel(this.m_set, this.m_field, bl);
        if (this.m_lock != null) {
            jSearchPanel.setLock(this.m_lock);
        }
        return jSearchPanel;
    }

    private class Listener
    implements TupleSetListener {
        private Listener() {
        }

        public void tupleSetChanged(TupleSet tupleSet, Tuple[] tupleArray, Tuple[] tupleArray2) {
            ((SearchBindingPredicate)SearchQueryBinding.this.getPredicate()).touch();
        }
    }

    private class SearchBindingPredicate
    extends AbstractPredicate {
        private SearchBindingPredicate() {
        }

        public boolean getBoolean(Tuple tuple) {
            String string = SearchQueryBinding.this.m_set.getQuery();
            return string == null || string.length() == 0 || SearchQueryBinding.this.m_set.containsTuple(tuple);
        }

        public void touch() {
            this.fireExpressionChange();
        }
    }
}

