/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import prefuse.data.Table;
import prefuse.data.io.AbstractTableWriter;
import prefuse.data.io.DataIOException;
import prefuse.data.io.FixedWidthTextTableSchema;
import prefuse.util.TypeLib;
import prefuse.util.collections.IntIterator;

public class FixedWidthTextTableWriter
extends AbstractTableWriter {
    private FixedWidthTextTableSchema m_schema;

    public FixedWidthTextTableWriter(FixedWidthTextTableSchema fixedWidthTextTableSchema) {
        this.m_schema = fixedWidthTextTableSchema;
    }

    public FixedWidthTextTableWriter(String string) throws DataIOException {
        this(FixedWidthTextTableSchema.load(string));
    }

    public FixedWidthTextTableSchema getFixedWidthSchema() {
        return this.m_schema;
    }

    public void setFixedWidthSchema(FixedWidthTextTableSchema fixedWidthTextTableSchema) {
        this.m_schema = fixedWidthTextTableSchema;
    }

    public void writeTable(Table table, OutputStream outputStream) throws DataIOException {
        try {
            PrintStream printStream = new PrintStream(new BufferedOutputStream(outputStream));
            char[] cArray = new char[table.getColumnCount()];
            boolean[] blArray = new boolean[table.getColumnCount()];
            for (int i = 0; i < table.getColumnCount(); ++i) {
                Class clazz = table.getColumnType(i);
                blArray[i] = TypeLib.isNumericType(clazz);
                cArray[i] = blArray[i] ? 48 : 32;
            }
            IntIterator intIterator = table.rows();
            while (intIterator.hasNext()) {
                int n = intIterator.nextInt();
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    printStream.print(FixedWidthTextTableWriter.pack(table.getString(n, i), this.m_schema.getColumnLength(i), blArray[i], cArray[i]));
                }
                printStream.println();
            }
            printStream.flush();
        }
        catch (Exception exception) {
            throw new DataIOException(exception);
        }
    }

    private static String pack(String string, int n, boolean bl, char c) {
        int n2 = string.length();
        if (n2 < n) {
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                stringBuffer.append(string);
            }
            for (int i = n; i < n2; ++i) {
                stringBuffer.append(c);
            }
            if (!bl) {
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        return string.substring(0, n);
    }
}

