/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import prefuse.data.io.DataIOException;
import prefuse.util.io.IOLib;

public class FixedWidthTextTableSchema {
    private String[] names = new String[0];
    private int[] cols = new int[1];

    private void ensureCapacity(int n) {
        String[] stringArray = new String[this.names.length + 1];
        System.arraycopy(this.names, 0, stringArray, 0, this.names.length);
        this.names = stringArray;
        int[] nArray = new int[this.cols.length + 1];
        System.arraycopy(this.cols, 0, nArray, 0, this.cols.length);
        this.cols = nArray;
    }

    public void addColumn(String string, int n) {
        int n2 = this.names.length;
        this.ensureCapacity(n2 + 1);
        this.names[n2] = string;
        this.cols[n2 + 1] = this.cols[n2] + n;
    }

    public int getColumnCount() {
        return this.names.length;
    }

    public String getColumnName(int n) {
        return this.names[n];
    }

    public int getColumnLength(int n) {
        return this.cols[n + 1] - this.cols[n];
    }

    public int getColumnStart(int n) {
        return this.cols[n];
    }

    public int getColumnEnd(int n) {
        return this.cols[n + 1];
    }

    public void write(String string) throws DataIOException {
        try {
            this.write(new FileOutputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DataIOException(fileNotFoundException);
        }
    }

    public void write(OutputStream outputStream) throws DataIOException {
        try {
            PrintStream printStream = new PrintStream(new BufferedOutputStream(outputStream));
            for (int i = 0; i < this.names.length; ++i) {
                printStream.print(this.names[i]);
                printStream.print('\t');
                printStream.print(this.cols[i + 1] - this.cols[i]);
                printStream.println();
            }
        }
        catch (Exception exception) {
            throw new DataIOException(exception);
        }
    }

    public static FixedWidthTextTableSchema load(String string) throws DataIOException {
        try {
            String string2;
            InputStream inputStream = IOLib.streamFromString(string);
            if (inputStream == null) {
                return null;
            }
            FixedWidthTextTableSchema fixedWidthTextTableSchema = new FixedWidthTextTableSchema();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split("\t");
                fixedWidthTextTableSchema.addColumn(stringArray[0], Integer.parseInt(stringArray[1]));
            }
            return fixedWidthTextTableSchema;
        }
        catch (Exception exception) {
            throw new DataIOException(exception);
        }
    }
}

