/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Logger;
import prefuse.data.DataReadOnlyException;
import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;

public class ObjectColumn
extends AbstractColumn {
    private Object[] m_values;
    private int m_size;

    public ObjectColumn() {
        this(Object.class);
    }

    public ObjectColumn(Class clazz) {
        this(clazz, 0, 10, null);
    }

    public ObjectColumn(int n) {
        this(Object.class, n, n, null);
    }

    public ObjectColumn(Class clazz, int n) {
        this(clazz, n, n, null);
    }

    public ObjectColumn(Class clazz, int n, int n2, Object object) {
        super(clazz, object);
        if (n2 < n) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_values = new Object[n2];
        try {
            Cloneable cloneable = (Cloneable)object;
            Method method = cloneable.getClass().getMethod("clone", null);
            for (int i = 0; i < n2; ++i) {
                this.m_values[i] = method.invoke(this.m_defaultValue, (Object[])null);
            }
        }
        catch (Exception exception) {
            if (object != null) {
                Logger.getLogger(this.getClass().getName()).fine("Default value of type \"" + object.getClass().getName() + "\" is not " + "cloneable. Using Object reference directly.");
            }
            Arrays.fill(this.m_values, object);
        }
        this.m_size = n;
    }

    public int getRowCount() {
        return this.m_size;
    }

    public void setMaximumRow(int n) {
        if (n > this.m_values.length) {
            int n2 = Math.max(3 * this.m_values.length / 2 + 1, n);
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.m_values, 0, objectArray, 0, this.m_size);
            try {
                Cloneable cloneable = (Cloneable)this.m_defaultValue;
                Method method = cloneable.getClass().getMethod("clone", null);
                for (int i = this.m_size; i < n2; ++i) {
                    objectArray[i] = method.invoke(this.m_defaultValue, (Object[])null);
                }
            }
            catch (Exception exception) {
                Arrays.fill(objectArray, this.m_size, n2, this.m_defaultValue);
            }
            this.m_values = objectArray;
        }
        this.m_size = n;
    }

    public void revertToDefault(int n) {
        try {
            Cloneable cloneable = (Cloneable)this.m_defaultValue;
            Method method = cloneable.getClass().getMethod("clone", null);
            this.set(method.invoke(this.m_defaultValue, (Object[])null), n);
        }
        catch (Exception exception) {
            this.set(this.m_defaultValue, n);
        }
    }

    public Object get(int n) {
        if (n < 0 || n > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n);
        }
        return this.m_values[n];
    }

    public void set(Object object, int n) {
        Object object2;
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (n < 0 || n > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n);
        }
        if (object == null || this.canSet(object.getClass())) {
            object2 = this.m_values[n];
            if (object2 == object) {
                return;
            }
        } else {
            throw new DataTypeException(object.getClass());
        }
        this.m_values[n] = object;
        this.fireColumnEvent(n, object2);
    }
}

