/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import prefuse.Display;
import prefuse.controls.ControlAdapter;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class SubtreeDragControl
extends ControlAdapter {
    private Point2D down = new Point2D.Double();
    private Point2D tmp = new Point2D.Double();
    private boolean wasFixed;

    public void itemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getSource();
        display.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void itemExited(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getSource();
        display.setCursor(Cursor.getDefaultCursor());
    }

    public void itemPressed(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getComponent();
        this.down = display.getAbsoluteCoordinate(mouseEvent.getPoint(), this.down);
        this.wasFixed = visualItem.isFixed();
        visualItem.setFixed(true);
    }

    public void itemReleased(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        visualItem.setFixed(this.wasFixed);
    }

    public void itemDragged(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (!(visualItem instanceof NodeItem)) {
            return;
        }
        Display display = (Display)mouseEvent.getComponent();
        this.tmp = display.getAbsoluteCoordinate(mouseEvent.getPoint(), this.tmp);
        double d = this.tmp.getX() - this.down.getX();
        double d2 = this.tmp.getY() - this.down.getY();
        this.updateLocations((NodeItem)visualItem, d, d2);
        this.down.setLocation(this.tmp);
        visualItem.getVisualization().repaint();
    }

    private void updateLocations(NodeItem nodeItem, double d, double d2) {
        double d3 = nodeItem.getX();
        double d4 = nodeItem.getY();
        nodeItem.setStartX(d3);
        nodeItem.setStartY(d4);
        nodeItem.setX(d3 += d);
        nodeItem.setY(d4 += d2);
        nodeItem.setEndX(d3);
        nodeItem.setEndY(d4);
        Iterator iterator = nodeItem.children();
        while (iterator.hasNext()) {
            this.updateLocations((NodeItem)iterator.next(), d, d2);
        }
    }
}

