/*
 * Decompiled with CFR 0.152.
 */
package prefuse.activity;

import prefuse.activity.ActivityListener;
import prefuse.activity.ActivityManager;
import prefuse.activity.Pacer;
import prefuse.util.collections.CopyOnWriteArrayList;

public abstract class Activity {
    public static final long INFINITY = -1L;
    public static final long DEFAULT_STEP_TIME = 15L;
    private boolean m_enabled = true;
    private Pacer m_pacer;
    private long m_startTime = -1L;
    private long m_duration = -1L;
    private long m_stepTime = -1L;
    private long m_nextTime = -1L;
    private boolean m_isRunning = false;
    private boolean m_isScheduled = false;
    private CopyOnWriteArrayList m_listeners;

    public Activity(long l) {
        this(l, 15L);
    }

    public Activity(long l, long l2) {
        this(l, l2, System.currentTimeMillis());
    }

    public Activity(long l, long l2, long l3) {
        this.m_startTime = l3;
        this.m_nextTime = l3;
        this.m_duration = l;
        this.m_stepTime = l2;
    }

    public void run() {
        ActivityManager.scheduleNow(this);
    }

    public void runAt(long l) {
        ActivityManager.scheduleAt(this, l);
    }

    public void runAfter(Activity activity) {
        ActivityManager.scheduleAfter(activity, this);
    }

    public void alwaysRunAfter(Activity activity) {
        ActivityManager.alwaysScheduleAfter(activity, this);
    }

    protected abstract void run(long var1);

    long runActivity(long l) {
        if (l < this.m_startTime) {
            return this.m_startTime - l;
        }
        long l2 = l - this.m_startTime;
        if (this.m_duration == 0L || l >= this.getStopTime()) {
            if (!this.setRunning(true)) {
                this.fireActivityStarted();
            }
            if (this.m_enabled) {
                this.run(l2);
                this.fireActivityStepped();
            }
            this.setRunning(false);
            this.fireActivityFinished();
            return -1L;
        }
        if (l >= this.m_nextTime) {
            if (!this.setRunning(true)) {
                this.fireActivityStarted();
            }
            if (this.m_enabled) {
                this.run(l2);
                this.fireActivityStepped();
            }
            this.m_nextTime = l + this.m_stepTime;
        }
        return this.m_nextTime - l;
    }

    public void cancel() {
        ActivityManager.cancelActivity(this);
    }

    public synchronized boolean isScheduled() {
        return this.m_isScheduled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setScheduled(boolean bl) {
        boolean bl2;
        Activity activity = this;
        synchronized (activity) {
            bl2 = bl && !this.m_isScheduled;
            this.m_isScheduled = bl;
        }
        if (bl2) {
            this.fireActivityScheduled();
        }
    }

    synchronized boolean setRunning(boolean bl) {
        boolean bl2 = this.m_isRunning;
        this.m_isRunning = bl;
        return bl2;
    }

    public synchronized boolean isRunning() {
        return this.m_isRunning;
    }

    public void addActivityListener(ActivityListener activityListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new CopyOnWriteArrayList();
        }
        if (!this.m_listeners.contains(activityListener)) {
            this.m_listeners.add(activityListener);
        }
    }

    public void removeActivityListener(ActivityListener activityListener) {
        if (this.m_listeners == null) {
            return;
        }
        this.m_listeners.remove(activityListener);
        if (this.m_listeners.size() == 0) {
            this.m_listeners = null;
        }
    }

    protected void fireActivityScheduled() {
        if (this.m_listeners == null) {
            return;
        }
        Object[] objectArray = this.m_listeners.getArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ActivityListener)objectArray[i]).activityScheduled(this);
        }
    }

    protected void fireActivityStarted() {
        if (this.m_listeners == null) {
            return;
        }
        Object[] objectArray = this.m_listeners.getArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ActivityListener)objectArray[i]).activityStarted(this);
        }
    }

    protected void fireActivityStepped() {
        if (this.m_listeners == null) {
            return;
        }
        Object[] objectArray = this.m_listeners.getArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ActivityListener)objectArray[i]).activityStepped(this);
        }
    }

    protected void fireActivityFinished() {
        if (this.m_listeners == null) {
            return;
        }
        Object[] objectArray = this.m_listeners.getArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ActivityListener)objectArray[i]).activityFinished(this);
        }
    }

    protected void fireActivityCancelled() {
        if (this.m_listeners == null) {
            return;
        }
        Object[] objectArray = this.m_listeners.getArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ActivityListener)objectArray[i]).activityCancelled(this);
        }
    }

    public double getPace(long l) {
        long l2 = this.getDuration();
        double d = l2 == 0L ? 0.0 : (double)l / (double)l2;
        d = Math.min(1.0, Math.max(0.0, d));
        return this.m_pacer != null ? this.m_pacer.pace(d) : d;
    }

    public synchronized Pacer getPacingFunction() {
        return this.m_pacer;
    }

    public synchronized void setPacingFunction(Pacer pacer) {
        this.m_pacer = pacer;
    }

    public long getStopTime() {
        if (this.m_duration == -1L) {
            return Long.MAX_VALUE;
        }
        return this.m_startTime + this.m_duration;
    }

    public long getNextTime() {
        return this.m_nextTime;
    }

    public long getDuration() {
        return this.m_duration;
    }

    public void setDuration(long l) {
        this.m_duration = l;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(long l) {
        this.m_startTime = l;
    }

    public long getStepTime() {
        return this.m_stepTime;
    }

    public void setStepTime(long l) {
        this.m_stepTime = l;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
    }
}

