/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.util.logging.Logger;
import prefuse.action.EncoderAction;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.visual.VisualItem;

public class ShapeAction
extends EncoderAction {
    protected int m_defaultShape = 0;

    public ShapeAction() {
    }

    public ShapeAction(String string) {
        super(string);
    }

    public ShapeAction(String string, int n) {
        super(string);
        this.m_defaultShape = n;
    }

    public int getDefaultSize() {
        return this.m_defaultShape;
    }

    public void setDefaultShape(int n) {
        this.m_defaultShape = n;
    }

    public void add(Predicate predicate, int n) {
        super.add(predicate, new Integer(n));
    }

    public void add(String string, int n) {
        Predicate predicate = (Predicate)ExpressionParser.parse(string);
        this.add(predicate, n);
    }

    public void add(Predicate predicate, ShapeAction shapeAction) {
        super.add(predicate, shapeAction);
    }

    public void add(String string, ShapeAction shapeAction) {
        Predicate predicate = (Predicate)ExpressionParser.parse(string);
        super.add(predicate, shapeAction);
    }

    public void process(VisualItem visualItem, double d) {
        visualItem.setShape(this.getShape(visualItem));
    }

    public int getShape(VisualItem visualItem) {
        Object object = this.lookup(visualItem);
        if (object != null) {
            if (object instanceof ShapeAction) {
                return ((ShapeAction)object).getShape(visualItem);
            }
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            Logger.getLogger(this.getClass().getName()).warning("Unrecognized Object from predicate chain.");
        }
        return this.m_defaultShape;
    }
}

