/*
 * Decompiled with CFR 0.152.
 */
package prefuse;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import prefuse.Display;
import prefuse.action.Action;
import prefuse.activity.Activity;
import prefuse.activity.ActivityMap;
import prefuse.data.CascadedTable;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tree;
import prefuse.data.Tuple;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.tuple.CompositeTupleSet;
import prefuse.data.tuple.DefaultTupleSet;
import prefuse.data.tuple.TupleManager;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.PrefuseConfig;
import prefuse.util.PrefuseLib;
import prefuse.util.collections.CompositeIterator;
import prefuse.visual.AggregateTable;
import prefuse.visual.VisualGraph;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;
import prefuse.visual.VisualTree;
import prefuse.visual.VisualTupleSet;
import prefuse.visual.expression.ValidatedPredicate;
import prefuse.visual.expression.VisiblePredicate;
import prefuse.visual.tuple.TableDecoratorItem;
import prefuse.visual.tuple.TableEdgeItem;
import prefuse.visual.tuple.TableNodeItem;

public class Visualization {
    public static final String ALL_ITEMS = PrefuseConfig.get("visualization.allItems");
    public static final String FOCUS_ITEMS = PrefuseConfig.get("visualization.focusItems");
    public static final String SELECTED_ITEMS = PrefuseConfig.get("visualization.selectedItems");
    public static final String SEARCH_ITEMS = PrefuseConfig.get("visualization.searchItems");
    private Map m_visual;
    private Map m_source;
    private Map m_focus;
    private ActivityMap m_actions = new ActivityMap();
    private RendererFactory m_renderers = new DefaultRendererFactory();
    private ArrayList m_displays;

    public Visualization() {
        this.m_visual = new LinkedHashMap();
        this.m_source = new HashMap();
        this.m_focus = new HashMap();
        this.m_displays = new ArrayList();
        this.addFocusGroup(FOCUS_ITEMS, new DefaultTupleSet());
        this.addFocusGroup(SELECTED_ITEMS, new DefaultTupleSet());
    }

    public synchronized VisualTupleSet add(String string, TupleSet tupleSet) {
        return this.add(string, tupleSet, null);
    }

    public synchronized VisualTupleSet add(String string, TupleSet tupleSet, Predicate predicate) {
        if (tupleSet instanceof Table) {
            return this.addTable(string, (Table)tupleSet, predicate);
        }
        if (tupleSet instanceof Tree) {
            return this.addTree(string, (Tree)tupleSet, predicate);
        }
        if (tupleSet instanceof Graph) {
            return this.addGraph(string, (Graph)tupleSet, predicate);
        }
        throw new IllegalArgumentException("Unsupported TupleSet type.");
    }

    protected void checkGroupExists(String string) {
        if (this.m_visual.containsKey(string) || this.m_focus.containsKey(string)) {
            throw new IllegalArgumentException("Group name '" + string + "' already in use");
        }
    }

    protected void addDataGroup(String string, VisualTupleSet visualTupleSet, TupleSet tupleSet) {
        this.checkGroupExists(string);
        this.m_visual.put(string, visualTupleSet);
        if (tupleSet != null) {
            this.m_source.put(string, tupleSet);
        }
    }

    public synchronized VisualTable addTable(String string) {
        VisualTable visualTable = new VisualTable(this, string);
        this.addDataGroup(string, visualTable, null);
        return visualTable;
    }

    public synchronized VisualTable addTable(String string, Schema schema) {
        VisualTable visualTable = new VisualTable(this, string, schema);
        this.addDataGroup(string, visualTable, null);
        return visualTable;
    }

    public synchronized VisualTable addTable(String string, Table table) {
        return this.addTable(string, table, (Predicate)null);
    }

    public synchronized VisualTable addTable(String string, Table table, Predicate predicate) {
        VisualTable visualTable = new VisualTable(table, this, string, predicate);
        this.addDataGroup(string, visualTable, table);
        return visualTable;
    }

    public synchronized VisualTable addTable(String string, Table table, Schema schema) {
        return this.addTable(string, table, null, schema);
    }

    public synchronized VisualTable addTable(String string, Table table, Predicate predicate, Schema schema) {
        VisualTable visualTable = new VisualTable(table, this, string, predicate, schema);
        this.addDataGroup(string, visualTable, table);
        return visualTable;
    }

    public synchronized VisualTable addTable(VisualTable visualTable) {
        this.addDataGroup(visualTable.getGroup(), visualTable, visualTable.getParentTable());
        visualTable.setVisualization(this);
        return visualTable;
    }

    public synchronized VisualGraph addGraph(String string, Graph graph) {
        return this.addGraph(string, graph, null);
    }

    public synchronized VisualGraph addGraph(String string, Graph graph, Predicate predicate) {
        return this.addGraph(string, graph, predicate, VisualItem.SCHEMA, VisualItem.SCHEMA);
    }

    public synchronized VisualGraph addGraph(String string, Graph graph, Predicate predicate, Schema schema, Schema schema2) {
        this.checkGroupExists(string);
        String string2 = PrefuseLib.getGroupName(string, Graph.NODES);
        String string3 = PrefuseLib.getGroupName(string, Graph.EDGES);
        VisualTable visualTable = this.addTable(string2, graph.getNodeTable(), predicate, schema);
        VisualTable visualTable2 = this.addTable(string3, graph.getEdgeTable(), predicate, schema2);
        VisualGraph visualGraph = new VisualGraph(visualTable, visualTable2, graph.isDirected(), graph.getNodeKeyField(), graph.getEdgeSourceField(), graph.getEdgeTargetField());
        visualGraph.setVisualization(this);
        visualGraph.setGroup(string);
        this.addDataGroup(string, visualGraph, graph);
        TupleManager tupleManager = new TupleManager(visualTable, visualGraph, TableNodeItem.class);
        TupleManager tupleManager2 = new TupleManager(visualTable2, visualGraph, TableEdgeItem.class);
        visualTable.setTupleManager(tupleManager);
        visualTable2.setTupleManager(tupleManager2);
        visualGraph.setTupleManagers(tupleManager, tupleManager2);
        return visualGraph;
    }

    public synchronized VisualTree addTree(String string, Tree tree) {
        return this.addTree(string, tree, null);
    }

    public synchronized VisualTree addTree(String string, Tree tree, Predicate predicate) {
        return this.addTree(string, tree, predicate, VisualItem.SCHEMA, VisualItem.SCHEMA);
    }

    public synchronized VisualTree addTree(String string, Tree tree, Predicate predicate, Schema schema, Schema schema2) {
        this.checkGroupExists(string);
        String string2 = PrefuseLib.getGroupName(string, Graph.NODES);
        String string3 = PrefuseLib.getGroupName(string, Graph.EDGES);
        VisualTable visualTable = this.addTable(string2, tree.getNodeTable(), predicate, schema);
        VisualTable visualTable2 = this.addTable(string3, tree.getEdgeTable(), predicate, schema2);
        VisualTree visualTree = new VisualTree(visualTable, visualTable2, tree.getNodeKeyField(), tree.getEdgeSourceField(), tree.getEdgeTargetField());
        visualTree.setVisualization(this);
        visualTree.setGroup(string);
        this.addDataGroup(string, visualTree, tree);
        TupleManager tupleManager = new TupleManager(visualTable, visualTree, TableNodeItem.class);
        TupleManager tupleManager2 = new TupleManager(visualTable2, visualTree, TableEdgeItem.class);
        visualTable.setTupleManager(tupleManager);
        visualTable2.setTupleManager(tupleManager2);
        visualTree.setTupleManagers(tupleManager, tupleManager2);
        return visualTree;
    }

    public synchronized AggregateTable addAggregates(String string) {
        return this.addAggregates(string, VisualItem.SCHEMA);
    }

    public synchronized AggregateTable addAggregates(String string, Schema schema) {
        AggregateTable aggregateTable = new AggregateTable(this, string, schema);
        this.addDataGroup(string, aggregateTable, null);
        return aggregateTable;
    }

    public synchronized VisualTable addDerivedTable(String string, String string2, Predicate predicate, Schema schema) {
        VisualTable visualTable = (VisualTable)this.getGroup(string2);
        VisualTable visualTable2 = new VisualTable(visualTable, this, string, predicate, schema);
        this.addDataGroup(string, visualTable2, this.getSourceData(string2));
        return visualTable2;
    }

    public synchronized VisualTable addDecorators(String string, String string2) {
        return this.addDecorators(string, string2, (Predicate)null);
    }

    public synchronized VisualTable addDecorators(String string, String string2, Schema schema) {
        return this.addDecorators(string, string2, null, schema);
    }

    public synchronized VisualTable addDecorators(String string, String string2, Predicate predicate) {
        VisualTable visualTable = this.addDerivedTable(string, string2, predicate, VisualItem.SCHEMA);
        visualTable.setTupleManager(new TupleManager(visualTable, null, TableDecoratorItem.class));
        return visualTable;
    }

    public synchronized VisualTable addDecorators(String string, String string2, Predicate predicate, Schema schema) {
        VisualTable visualTable = this.addDerivedTable(string, string2, predicate, schema);
        visualTable.setTupleManager(new TupleManager(visualTable, null, TableDecoratorItem.class));
        return visualTable;
    }

    public synchronized boolean removeGroup(String string) {
        Object object;
        TupleSet tupleSet = this.getFocusGroup(string);
        if (tupleSet != null) {
            Iterator iterator = tupleSet.tuples(ValidatedPredicate.TRUE);
            while (iterator.hasNext()) {
                ((VisualItem)iterator.next()).setValidated(false);
            }
            tupleSet.clear();
            this.m_focus.remove(string);
            return true;
        }
        tupleSet = this.getVisualGroup(string);
        if (tupleSet == null) {
            return false;
        }
        TupleSet[] tupleSetArray = new TupleSet[this.m_focus.size()];
        this.m_focus.values().toArray(tupleSetArray);
        Object object2 = tupleSet.tuples();
        while (object2.hasNext()) {
            object = (VisualItem)object2.next();
            for (int i = 0; i < tupleSetArray.length; ++i) {
                tupleSetArray[i].removeTuple((Tuple)object);
            }
            object.setValidated(false);
        }
        if (tupleSet instanceof CompositeTupleSet) {
            object2 = (CompositeTupleSet)tupleSet;
            object = ((CompositeTupleSet)object2).setNames();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                String string3 = PrefuseLib.getGroupName(string, string2);
                this.m_visual.remove(string3);
                this.m_source.remove(string3);
            }
        }
        this.m_visual.remove(string);
        this.m_source.remove(string);
        return true;
    }

    public synchronized void reset() {
        for (Map.Entry entry : this.m_focus.entrySet()) {
            TupleSet tupleSet = (TupleSet)entry.getValue();
            tupleSet.clear();
        }
        this.m_visual.clear();
        this.m_source.clear();
    }

    public TupleSet getSourceData(String string) {
        return (TupleSet)this.m_source.get(string);
    }

    public TupleSet getSourceData(VisualTupleSet visualTupleSet) {
        return (TupleSet)this.m_source.get(visualTupleSet.getGroup());
    }

    public Tuple getSourceTuple(VisualItem visualItem) {
        Object object;
        String string = visualItem.getGroup();
        TupleSet tupleSet = this.getSourceData(string);
        if (tupleSet == null) {
            return null;
        }
        int n = visualItem.getRow();
        Table table = visualItem.getTable();
        while (table instanceof VisualTable) {
            object = (VisualTable)table;
            n = ((CascadedTable)object).getParentRow(n);
            table = ((CascadedTable)object).getParentTable();
        }
        object = PrefuseLib.getChildGroup(string);
        if (object != null) {
            String string2 = PrefuseLib.getParentGroup(string);
            Graph graph = (Graph)this.getSourceData(string2);
            if (table == graph.getNodeTable()) {
                return graph.getNode(n);
            }
            return graph.getEdge(n);
        }
        return table.getTuple(n);
    }

    public VisualItem getVisualItem(String string, Tuple tuple) {
        VisualTable visualTable;
        TupleSet tupleSet = this.getVisualGroup(string);
        if (tupleSet instanceof VisualTable) {
            visualTable = (VisualTable)tupleSet;
        } else if (tupleSet instanceof Graph) {
            Graph graph = (Graph)tupleSet;
            visualTable = (VisualTable)(tuple instanceof Node ? graph.getNodeTable() : graph.getEdgeTable());
        } else {
            return null;
        }
        int n = tuple.getRow();
        int n2 = visualTable.getChildRow(n);
        return n2 < 0 ? null : visualTable.getItem(n2);
    }

    public TupleSet getGroup(String string) {
        TupleSet tupleSet = this.getVisualGroup(string);
        if (tupleSet == null) {
            tupleSet = this.getFocusGroup(string);
        }
        return tupleSet;
    }

    public boolean isInGroup(VisualItem visualItem, String string) {
        if (ALL_ITEMS.equals(string)) {
            return true;
        }
        if (visualItem.getGroup() == string) {
            return true;
        }
        TupleSet tupleSet = this.getGroup(string);
        return tupleSet == null ? false : tupleSet.containsTuple(visualItem);
    }

    public void addFocusGroup(String string) {
        this.checkGroupExists(string);
        this.m_focus.put(string, new DefaultTupleSet());
    }

    public void addFocusGroup(String string, TupleSet tupleSet) {
        this.checkGroupExists(string);
        this.m_focus.put(string, tupleSet);
    }

    public int size(String string) {
        TupleSet tupleSet = this.getGroup(string);
        return tupleSet == null ? 0 : tupleSet.getTupleCount();
    }

    public TupleSet getVisualGroup(String string) {
        return (TupleSet)this.m_visual.get(string);
    }

    public TupleSet getFocusGroup(String string) {
        return (TupleSet)this.m_focus.get(string);
    }

    public void invalidate(String string) {
        Iterator iterator = this.items(string, ValidatedPredicate.TRUE);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            visualItem.setValidated(false);
        }
    }

    public void invalidateAll() {
        this.invalidate(ALL_ITEMS);
    }

    public Iterator visibleItems() {
        return this.items(VisiblePredicate.TRUE);
    }

    public Iterator visibleItems(String string) {
        return this.items(string, VisiblePredicate.TRUE);
    }

    public Iterator items() {
        return this.items((Predicate)null);
    }

    public Iterator items(Predicate predicate) {
        int n = this.m_visual.size();
        if (n == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (n == 1) {
            Iterator iterator = this.m_visual.keySet().iterator();
            return this.items((String)iterator.next(), predicate);
        }
        CompositeIterator compositeIterator = new CompositeIterator(this.m_visual.size());
        Iterator iterator = this.m_visual.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (PrefuseLib.isChildGroup(string)) continue;
            compositeIterator.setIterator(n2++, this.items(string, predicate));
        }
        return compositeIterator;
    }

    public Iterator items(String string) {
        return this.items(string, (Predicate)null);
    }

    public Iterator items(String string, String string2) {
        Expression expression = ExpressionParser.parse(string2);
        if (!(expression instanceof Predicate) || ExpressionParser.getError() != null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.items(string, (Predicate)expression);
    }

    public Iterator items(String string, Predicate predicate) {
        if (ALL_ITEMS.equals(string)) {
            return this.items(predicate);
        }
        TupleSet tupleSet = this.getGroup(string);
        return tupleSet == null ? Collections.EMPTY_LIST.iterator() : tupleSet.tuples(predicate);
    }

    public void setValue(String string, Predicate predicate, String string2, Object object) {
        Iterator iterator = this.items(string, predicate);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            visualItem.set(string2, object);
        }
    }

    public void setVisible(String string, Predicate predicate, boolean bl) {
        Iterator iterator = this.items(string, predicate);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            visualItem.setVisible(bl);
        }
    }

    public void setInteractive(String string, Predicate predicate, boolean bl) {
        Iterator iterator = this.items(string, predicate);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            visualItem.setInteractive(bl);
        }
    }

    public Action putAction(String string, Action action) {
        action.setVisualization(this);
        this.m_actions.put(string, action);
        return action;
    }

    public Action getAction(String string) {
        return (Action)this.m_actions.get(string);
    }

    public Action removeAction(String string) {
        Action action = this.getAction(string);
        if (action != null) {
            action.cancel();
            this.m_actions.remove(string);
            action.setVisualization(null);
        }
        return action;
    }

    public Activity run(String string) {
        return this.m_actions.run(string);
    }

    public Activity runAfter(String string, long l) {
        return this.m_actions.runAt(string, System.currentTimeMillis() + l);
    }

    public Activity runAt(String string, long l) {
        return this.m_actions.runAt(string, l);
    }

    public Activity runAfter(String string, String string2) {
        return this.m_actions.runAfter(string, string2);
    }

    public Activity alwaysRunAfter(String string, String string2) {
        return this.m_actions.alwaysRunAfter(string, string2);
    }

    public Activity cancel(String string) {
        return this.m_actions.cancel(string);
    }

    public void setRendererFactory(RendererFactory rendererFactory) {
        this.invalidateAll();
        this.m_renderers = rendererFactory;
    }

    public RendererFactory getRendererFactory() {
        return this.m_renderers;
    }

    public Renderer getRenderer(VisualItem visualItem) {
        if (visualItem.getVisualization() != this) {
            throw new IllegalArgumentException("Input item not a member of this visualization.");
        }
        return this.m_renderers.getRenderer(visualItem);
    }

    public synchronized void repaint() {
        Iterator iterator = this.items(ValidatedPredicate.FALSE);
        while (iterator.hasNext()) {
            ((VisualItem)iterator.next()).validateBounds();
        }
        for (int i = 0; i < this.m_displays.size(); ++i) {
            this.getDisplay(i).repaint();
        }
    }

    public Rectangle2D getBounds(String string) {
        return this.getBounds(string, new Rectangle2D.Double());
    }

    public Rectangle2D getBounds(String string, Rectangle2D rectangle2D) {
        VisualItem visualItem;
        Iterator iterator = this.visibleItems(string);
        if (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            rectangle2D.setRect(visualItem.getBounds());
        }
        while (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            Rectangle2D.union(visualItem.getBounds(), rectangle2D, rectangle2D);
        }
        return rectangle2D;
    }

    public int getDisplayCount() {
        return this.m_displays.size();
    }

    void addDisplay(Display display) {
        this.m_displays.add(display);
    }

    public Display getDisplay(int n) {
        return (Display)this.m_displays.get(n);
    }

    boolean removeDisplay(Display display) {
        return this.m_displays.remove(display);
    }

    public void damageReport(VisualItem visualItem, Rectangle2D rectangle2D) {
        for (int i = 0; i < this.m_displays.size(); ++i) {
            Display display = this.getDisplay(i);
            if (!display.getPredicate().getBoolean(visualItem)) continue;
            display.damageReport(rectangle2D);
        }
    }
}

